//***********************************************************************
//Copyright © 2009-2012 Corporation for National Research Initiatives
//("CNRI"). This software is made available under the terms of the
//CNRI License Agreement  that is located at hdl:1895.26/1012
//or http://hdl.handle.net/1895.26/1012.
//***********************************************************************
//Developer: Kevin Hosford
//Developer: Robert R Tupelo-Schneck <schneck@cnri.reston.va.us>
//***********************************************************************

if(typeof net === "undefined") net = {};
if(typeof net.cnri === "undefined") net.cnri = {};
if(typeof net.cnri.firefoxextension === "undefined") net.cnri.firefoxextension = {};

(function() {
    var handleLinkFinder = {
        init: function() {
            var appcontent = document.getElementById("appcontent");
            if(appcontent) {
                appcontent.addEventListener("DOMContentLoaded", handleLinkFinder.onPageLoad, true);
            }
        },
    
        onPageLoad: function(aEvent) {
            var theDocument = aEvent.originalTarget;
            if(theDocument instanceof HTMLDocument) {
              try {
                if(typeof handleLinkFinder.component === "undefined") {
                    handleLinkFinder.component = Components.classes["@cnri.net/handle-link-finder;1"].getService().wrappedJSObject;
                }
                if(handleLinkFinder.component.findLinks) {
                    handleLinkFinder.component.makeLinks(theDocument);
                }
              } catch(err) {
                  Components.classes["@mozilla.org/consoleservice;1"]
                  .getService(Ci.nsIConsoleService)
                      .logStringMessage(err);
              }
            }
        }
    };
    net.cnri.firefoxextension.handleLinkFinder = handleLinkFinder;
})();

window.addEventListener("load", function() { net.cnri.firefoxextension.handleLinkFinder.init(); }, false);

